﻿using System;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

namespace MVC_App.Models
{
	public class BestellungForm
	{
		public LieferadresseForm Lieferadresse { get; set; }

		public Lieferzeitpunkte LieferzeitpunktArt { get; set; }
		public LieferzeitpunktForm Lieferzeitpunkt { get; set; }

		public Zahlmodi Zahlmodus { get; set; }
		public KreditkarteForm Kreditkarte { get; set; }

		public bool HasGetränk { get; set; }
		public GetränkForm Getränk { get; set; }

		public bool HasDessert { get; set; }
		public DessertForm Dessert { get; set; }

		public PizzaForm Pizza { get; set; }

		public SelectList LieferzeitpunktListe
		{
			get { return new SelectList(Enum.GetNames(typeof(Lieferzeitpunkte))); }
		}
		public SelectList FlaschengrößeListe
		{
			get
			{
				return new SelectList(new[]
				                      	{
				                      		new {Value = "3",  Text = "0,3 Liter"},
				                      		new {Value = "5",  Text = "0,5 Liter"},
				                      		new {Value = "10", Text = "1,0 Liter"},
				                      		new {Value = "15", Text = "1,5 Liter"}
				                      	}, "Value", "Text");
			}
		}
		public SelectList GetränkListe
		{
			get { return new SelectList(Enum.GetNames(typeof(Getränke))); }
		}
		public SelectList DessertListe
		{
			get { return new SelectList(Enum.GetNames(typeof(Desserts))); }
		}
		public SelectList ZahlmodusListe
		{
			get { return new SelectList(Enum.GetNames(typeof(Zahlmodi))); }
		}
		public SelectList MonatListe
		{
			get { return new SelectList(new[] { "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", }); }
		}
		public SelectList JahrListe
		{
			get { return new SelectList(new[] { "2012", "2013", "2014", "2015", "2016", "2017", "2018" }); }
		}
		public SelectList PizzaGrößen
		{
			get { return new SelectList(new[] { Models.PizzaGrößen.Mittel, Models.PizzaGrößen.Groß, Models.PizzaGrößen.Extragroß }); }
		}
		public SelectList PizzaSorten
		{
			get { return new SelectList(PizzaRepository.Sorten); }
		}
	}

	public class LieferadresseForm
	{
		[Required]
		public string Straße { get; set; }

		[Required]
		public int? Hausnummer { get; set; }

		[Required]
		[StringLength(5, MinimumLength = 5)]
		public string Plz { get; set; }

		[Required]
		public string Ort { get; set; }
	}

	public class LieferzeitpunktForm
	{
		public string Uhrzeit { get; set; }
		public string Datum { get; set; }
	}
	
	public class KreditkarteForm
	{
		public string Name { get; set; }
		public string Nummer { get; set; }
		public string GültigBisMonat { get; set; }
		public string GültigBisJahr { get; set; }
	}

	public class GetränkForm
	{
		public string Name { get; set; }
		public string Flaschengröße { get; set; }
		public bool Gekühlt { get; set; }
	}

	public class PizzaForm
	{
		public PizzaGrößen? Größe { get; set; }
		public string Sorte { get; set; }
	}

	public class DessertForm
	{
		public Desserts? Name { get; set; }
	}
}